/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.IWSTypeEntry;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSType;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.symbolTable.CollectionElement;
import org.apache.axis.wsdl.symbolTable.DefinedElement;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSDefinedElement
implements IWSTypeEntry {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "IWSTypeEntry";
    private WSDefinition m_definition = null;
    private DefinedElement m_element = null;
    private IWSTypeEntry[] m_references = null;
    private String m_name = null;
    private String m_maxOccurs = "1";
    private String m_minOccurs = "1";

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.13  $";
    }

    public void releaseReferences() {
        block4: {
            try {
                this.m_definition = null;
                this.m_element = null;
                IWSTypeEntry type = null;
                if (this.m_references != null) {
                    IWSTypeEntry[] references = this.m_references;
                    this.m_references = null;
                    for (int i = 0; i < references.length; ++i) {
                        if (references[i] == null) continue;
                        type = references[i];
                        references[i] = null;
                        type.releaseReferences();
                    }
                    Object var2_3 = null;
                }
                this.m_name = null;
                this.m_maxOccurs = null;
                this.m_minOccurs = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSDefinedElement(WSDefinition definition, DefinedElement element) {
        this.m_definition = definition;
        if (element != null) {
            if (element instanceof CollectionElement) {
                this.m_maxOccurs = Utils.getAttribute((Node)((CollectionElement)element).getNode(), (String)"maxOccurs");
                this.m_minOccurs = Utils.getAttribute((Node)((CollectionElement)element).getNode(), (String)"minOccurs");
            }
            this.m_element = element;
            Vector<IWSTypeEntry> references = new Vector<IWSTypeEntry>();
            TypeEntry refTypeEntry = element.getRefType();
            references.add(this.m_definition.getTypeEntry(refTypeEntry));
            while (refTypeEntry != null) {
                if ((refTypeEntry = refTypeEntry.getRefType()) == null) continue;
                references.add(this.m_definition.getTypeEntry(refTypeEntry));
            }
            if (references != null && references.size() > 0) {
                this.m_references = new IWSTypeEntry[references.size()];
                references.toArray(this.m_references);
                references.removeAllElements();
            }
        }
    }

    public String getName() {
        if (this.m_name != null) {
            return this.m_name;
        }
        if (this.m_element != null) {
            Node attrib;
            NamedNodeMap attributes;
            if (this.m_element.getQName() != null) {
                this.m_name = this.m_element.getQName().getLocalPart();
            }
            if (this.m_name != null) {
                return this.m_name;
            }
            Node node = this.m_element.getNode();
            if (node != null && (attributes = node.getAttributes()) != null && (attrib = attributes.getNamedItem("name")) != null) {
                this.m_name = attrib.getNodeValue();
                if (this.m_name != null && this.m_name.lastIndexOf(">") != -1) {
                    this.m_name = this.m_name.substring(this.m_name.lastIndexOf(">") + 1);
                }
                return this.m_name;
            }
        }
        return null;
    }

    public String getDisplayName() {
        if (this.m_element != null) {
            return this.m_element.getQName().getLocalPart();
        }
        return null;
    }

    public QName getQName() {
        if (this.m_element != null) {
            return this.m_element.getQName();
        }
        return null;
    }

    public DefinedElement getDefinedElement() {
        return this.m_element;
    }

    public boolean isCollectionParent(boolean bRPC) {
        if (this.m_element instanceof CollectionElement) {
            return true;
        }
        if (this.m_references != null && this.m_references.length > 0) {
            for (int i = 0; i < this.m_references.length; ++i) {
                if (this.m_references[i] == null || !(this.m_references[i] instanceof WSType ? ((WSType)this.m_references[i]).isCollectionType() : this.m_references[i] instanceof WSDefinedElement && ((WSDefinedElement)this.m_references[i]).isCollectionElement())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCollectionElement() {
        return this.m_element instanceof CollectionElement;
    }

    public String getNamespace() {
        if (this.m_element != null && this.m_element.getQName() != null) {
            return this.m_element.getQName().getNamespaceURI();
        }
        return null;
    }

    public String getNamespacePrefix() {
        String namespace = this.getNamespace();
        if (namespace != null && namespace.length() > 0 && this.m_definition != null) {
            return this.m_definition.getNamespacePrefix(namespace);
        }
        return null;
    }

    public String getTypeLocalName() {
        String s = this.m_element.getQName().getLocalPart();
        if (this.isCollectionElement()) {
            if (s.indexOf("[]") == 0) {
                s = s + "[]";
            } else {
                int idx = s.indexOf("[");
                if (idx != 0) {
                    s = s.substring(0, idx) + "[]";
                }
            }
        }
        return s;
    }

    public IWSTypeEntry getRefTypeEntry() {
        if (this.m_references != null && this.m_references.length > 0) {
            return this.m_references[this.m_references.length - 1];
        }
        return null;
    }

    public IWSTypeEntry[] getReferences() {
        return this.m_references;
    }

    public String getMaxOccurs() {
        return this.m_maxOccurs;
    }

    public String getMinOccurs() {
        return this.m_minOccurs;
    }

    public String toString() {
        if (this.m_element.getName() != null) {
            return this.m_element.getName().toString();
        }
        return null;
    }
}

